function design = MISC_1d(n, d, MISC)
%MISC_1D Generates a 1D MISC array.
%Syntax:
%   design = MISC_1d(n, wavelength/2, 'MISC Array');
%Inputs:
%   n - sensor amount.
%   d - Inter-element spacing.
%   name - Custom name of the array. Default is 'MISC array (m)'.
%Outputs:
%   design - An array design struct.
if n <= 7
    error('Sensor amount must larger than 7.');
end
% ========= array configuration ============
% ========= decide spacing
q = floor((n)/4);
S_n = 2*q+2;
% ========= subarray designs ===========
% ========= initial parameters
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
sub1=[0 1];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
sub2=[];
for sub2_count = 1:(n-S_n)
    sub2(sub2_count)= 0 + (sub2_count-1)*S_n;
end
sub2 = sub2 + S_n - 2;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
sub3=[];

for sub3_count = 1:((S_n-4)/2 + 1)
    sub3(sub3_count)= 0 + (sub3_count-1)*2;
end
sub4 = sub3;
sub3 = sub3 + (n-S_n+1)*S_n-2;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
sub4 = sub4 + (n-S_n+2)*S_n-3;;


if d <= 0 || ~isreal(d)
    error('d must be a positive real number.');
end
if nargin <= 2
    name = sprintf('MISC array %d sensors', n);
elseif ~ischar(name)
    error('Name must be a string.');
end
design.element_indices = [sub1 sub2 sub3 sub4];
%design.element_indices = union(design.element_indices, (n1*n2+n2+n1-2));
design.element_positions = design.element_indices*d;
design.element_spacing = d;
design.element_count = length(design.element_indices);
design.dim = 1;
design.type = 'MISC Subarray';
design.name = name;
end